local t = LoadFallbackB();

if not GAMESTATE:IsCourseMode() then
	local function GenerateModIconRow(pn)
		local MetricsName = "ModIcons" .. ToEnumShortString(pn);
		return Def.ActorFrame {
			InitCommand=function(self) self:name(MetricsName); ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); end;
			LoadActor( THEME:GetPathG("OptionIcon","Player") )..{
				InitCommand=cmd(pause;halign,0;x,-19);
				BeginCommand=function(self)
					self:setstate( pn == PLAYER_1 and 0 or 1 );
				end;
				OnCommand=cmd(zoomy,0;linear,0.5;zoomy,1;);
				OffCommand=cmd(linear,0.5;zoomy,0;);
			};
			Def.ModIconRow {
				InitCommand=cmd(Load,"ModIconRowSelectMusic"..ToEnumShortString(pn),pn;x,152;);
				OnCommand=cmd(zoomy,0;linear,0.5;zoomy,1;);
				OffCommand=cmd(linear,0.5;zoomy,0;);
			};
		};
	end;

	for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
		if ShowStandardDecoration("ModIcons") then
			t[#t+1] = GenerateModIconRow(pn);
		end
	end;
end;

t[#t+1] = StandardDecorationFromFile("BannerFrame","BannerFrame")
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay")
t[#t+1] = StandardDecorationFromFileOptional("SortDisplay","SortDisplay")
t[#t+1] = StandardDecorationFromFileOptional("AvailableDifficulties", "AvailableDifficulties")

-- difficulty icons
if ShowStandardDecoration("DifficultyIcons") then
	for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
		local diffFrame = LoadActor(THEME:GetPathG(Var "LoadingScreen", "DifficultyFrame"), pn)
		t[#t+1] = StandardDecorationFromTable( "DifficultyFrame" .. ToEnumShortString(pn), diffFrame );

		local diffIcon = LoadActor(THEME:GetPathG(Var "LoadingScreen", "DifficultyIcon"), pn)
		t[#t+1] = StandardDecorationFromTable( "DifficultyIcon" .. ToEnumShortString(pn), diffIcon );
	end
end

t[#t+1] = StandardDecorationFromFileOptional("GrooveRadar","GrooveRadar")

-- StepsDisplay
local function StepsDisplay(pn)
	local function set(self, player)
		self:SetFromGameState(player);
	end

	local name = "StepsDisplaySelMusic";

	local sd = Def.StepsDisplay {
		InitCommand=cmd(Load,name..ToEnumShortString(pn),GAMESTATE:GetPlayerState(pn););
		CurrentSongChangedMessageCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			if not song then
				-- hacky hack 1: set all feet to nothing!
				self:GetChild("Ticks"):settext("0000000000");
				-- hacky hack 2: diffuse to beginner
				self:GetChild("Ticks"):diffuse(CustomDifficultyToColor("Beginner"))
			end
		end;
	};

	if pn == PLAYER_1 then
		sd.CurrentStepsP1ChangedMessageCommand=function(self) set(self, pn); end;
		sd.CurrentTrailP1ChangedMessageCommand=function(self) set(self, pn); end;
	else
		sd.CurrentStepsP2ChangedMessageCommand=function(self) set(self, pn); end;
		sd.CurrentTrailP2ChangedMessageCommand=function(self) set(self, pn); end;
	end

	return sd;
end

if ShowStandardDecoration("StepsDisplay") then
	for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
		-- frame
		local meterFrame = LoadActor(THEME:GetPathG(Var "LoadingScreen", "MeterFrame"), pn)
		t[#t+1] = StandardDecorationFromTable( "MeterFrame" .. ToEnumShortString(pn), meterFrame );

		-- stepsdisplay
		local MetricsName = "StepsDisplay" .. PlayerNumberToString(pn);
		t[#t+1] = StepsDisplay(pn) .. {
			InitCommand=function(self)
				self:player(pn);
				self:name(MetricsName);
				ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen");
			end;
		};
	end
end

-- song options text (e.g. 1.5xmusic)
t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptions")

if AllowOptionsMenu() then
	t[#t+1] = StandardDecorationFromFile("OptionsMessage","OptionsMessage")
end

-- other items (balloons, etc.)

t[#t+1] = LoadActor("help")..{ 
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-33.5;);
	OnCommand=cmd(draworder,199;shadowlength,0;diffuseblink;linear,0.5);
}

t[#t+1] = LoadActor("_shared header")..{ 
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-215;);
	OnCommand=cmd(draworder,50);
}

t[#t+1] = Def.ActorFrame{
	InitCommand=cmd(zoom,0.95);
	LoadActor("_ModP1")..{
		BeginCommand=cmd(visible,GAMESTATE:IsHumanPlayer('PlayerNumber_P1',0));
		InitCommand=cmd(x,SCREEN_CENTER_X-323;y,SCREEN_CENTER_Y-156;draworder,1;addx,-SCREEN_WIDTH*0.625;bounceend,0.5;addx,SCREEN_WIDTH*0.625);
		OnCommand=cmd(zoom,0.7);
		OffCommand=cmd(bouncebegin,0.5;addx,-SCREEN_WIDTH*0.625);
	};
	
	LoadActor("_ModP2")..{
		BeginCommand=cmd(visible,GAMESTATE:IsHumanPlayer('PlayerNumber_P2',1));
		InitCommand=cmd(x,SCREEN_CENTER_X-323;y,SCREEN_CENTER_Y-160;draworder,1;addx,-SCREEN_WIDTH*0.625;bounceend,0.5;addx,SCREEN_WIDTH*0.625);
		OnCommand=cmd(zoom,0.7);
		OffCommand=cmd(bouncebegin,0.5;addx,-SCREEN_WIDTH*0.625);
	};
};

return t